local fadeout
local credits = {
	"UPSRT",
	"Credit Roll",

	"","",
	"Dan \"dbk2\" Guzek  -  Programming, Original Music, Writing",
	"Caitlin \"HUGS\" Schaeppi  -  Visual Art, Writing",
	"Alan \"TaroNuke\" James  -  Battle Scripting",

	"","",

	"Translation Team",
	"Español - Seth Hammond",
	"Français - Benoit Gilbert",
	"한국인 - Feedbacker",
	"日本語 - Sujeet Bhandari",

	"","",

	"~  Special Thanks  ~",
	"Mad Matt, kyzentun, teejusb  -  programming assistance",
	"Mute - Simfile Sync",
	"RPG Maker XP  -  inspiration + a few visual assets",
	"Darren Rigby  -  Enigmatic Unicode Font",

	"","",

	"UPSRT Features Music By...",
	"Pendulum",
	"S.S.H., The J. Arthur Keenes Band, and Cardboard Box vs. STereochan",
	"Phoenix + Alex Metric, PrototypeRaptor, Sota Fujimori, and Yoko Shimomura",

	"","","","","",
	"Thank You For Playing!"
}

local af = Def.ActorFrame{
	-- Sky
	Def.Quad{
		InitCommand=function(self)
			self:FullScreen():Center():diffuseleftedge( 0.8,0.5,0.625,1):diffuserightedge(0.45,0.6,0.85,1)
		end,
		OnCommand=function(self)
			for i, event_actor in ipairs(SRT.EventActors) do
				event_actor:queuecommand("UpdateSpriteFrames"):queuecommand("Reposition")
			end
			self:sleep(30):linear(10):diffuse(0.1,0.1,0.1,1)
		end
	},

	-- Clouds
	LoadActor("clouds.png")..{
		InitCommand=function(self)
			self:FullScreen():Center():diffusealpha(0.5):diffuseleftedge( 1,0.8,0.75,1 )
				:customtexturerect(0,0,1,1):texcoordvelocity(-0.005,0)
		end,
		OnCommand=function(self) self:sleep(30):linear(5):diffusealpha(0) end
	},
}

local CreditsAF = Def.ActorFrame{
	InitCommand=function(self) self:y(350):diffusealpha(0) end,
	OnCommand=function(self) self:sleep(1.5):diffusealpha(1):linear(55):y(-950):sleep(4):queuecommand("FadeOut") end,
	FadeOutCommand=function(self)
		fadeout:accelerate(4):diffuse(0,0,0,1)
		self:sleep(5):queuecommand("Transition")
	end,
	TransitionCommand=function(self)
		local topscreen = SCREENMAN:GetTopScreen()
		topscreen:SetNextScreenName("Title")
		SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
	end
}

for i,credit in ipairs(credits) do
	CreditsAF[#CreditsAF+1] = Def.BitmapText{
		Font="Common normal",
		Text=credit,
		InitCommand=function(self)
			self:xy(_screen.cx, i*34):zoom(0.8)
				:diffuse(0.15,0.15,0.15,1)

			if i >= #credits-16 then
				self:diffuse(1,1,1,1)
			end
		end
	}
end

af[#af+1] = CreditsAF


-------------------------------------------------------------------

Reen 		= setmetatable({},NPC):new( 10,6, "../Reen 4x4.png", "Up" )
LittleMatt 	= setmetatable({},NPC):new( 10.33, 6.5, "LittleMatt 4x4.png", "Up" )
Sami 		= setmetatable({},NPC):new( 9.66, 6.5, "Sami 4x4.png", "Up" )
MadMatt 	= setmetatable({},NPC):new( 10.66, 7, "MadMatt 4x4.png", "Up" )
Archi 		= setmetatable({},NPC):new( 9.33, 7, "Archi 4x4.png", "Up" )


-- t exists as a container to tween the entire Earth (ground, characters) up and down
-- without worry about the effects of fov(90) applied to t2
local t = Def.ActorFrame{
	InitCommand=function(self) self:y(10):z(200) end,
	OnCommand=function(self) self:decelerate(15):z(0):sleep(15):accelerate(15):y(500) end
}

local t2 = Def.ActorFrame{
	InitCommand=function(self) self:CenterY():fov(90):rotationx(-83.5) end,
	OnCommand=function(self)
		self:sleep(32.5):linear(3):diffusealpha(0)
	end,

	-- Grass
	LoadActor("./under.png")..{
		OnCommand=function(self)
			self:FullScreen():zoom(0.425)
				:customtexturerect(0,0,1,1):texcoordvelocity(0,-0.02)
				:diffusetopedge(0.2,0.4,0.1,1)
				:diffuseupperleft(0.2,0.3,0.025,1)
				:fadetop(0.0175)
		end
	},
}


t2[#t2+1] = Reen.Actor(1)..{ OnCommand=function(self) self:rotationx(82.5):zoom(0.4):diffuseleftedge(0.6,0.6,0.5,1) end }
t2[#t2+1] = LittleMatt.Actor(2)..{ OnCommand=function(self) self:rotationx(82.5):zoom(0.4):diffuseleftedge(0.6,0.6,0.5,1) end }
t2[#t2+1] = Sami.Actor(3)..{ OnCommand=function(self) self:rotationx(82.5):zoom(0.4):diffuseleftedge(0.6,0.6,0.5,1) end }
t2[#t2+1] = MadMatt.Actor(4)..{ OnCommand=function(self) self:rotationx(82.5):zoom(0.4):diffuseleftedge(0.6,0.6,0.5,1) end }
t2[#t2+1] = Archi.Actor(5)..{ OnCommand=function(self) self:rotationx(82.5):zoom(0.4):diffuseleftedge(0.6,0.6,0.5,1) end }

-- trees on the right
for i=1,100,10 do
	t2[#t2+1] = LoadActor("tree.png")..{
		InitCommand=function(self)
			self:xy(_screen.cx + _screen.w/1.5, -1000):z(-60)
				:rotationx(82.50):zoom(0)
				:draworder( 100-i )
				:diffuseleftedge(0.3,0.6,0.2,1)
				:diffuserightedge(0.8,1,0.6,1)
		end,
		OnCommand=function(self)
			self:sleep(3 + i/3):accelerate(15):y(_screen.h):zoom(3)
		end
	}
end

-- trees on the left
for i=5,100,10 do
	t2[#t2+1] = LoadActor("tree.png")..{
		InitCommand=function(self)
			self:xy((-_screen.cx/2), -1000):z(-60)
				:rotationx(82.50):zoom(0)
				:draworder( 100-i )
				:diffuseleftedge(0.3,0.6,0.2,1)
		end,
		OnCommand=function(self)
			self:sleep(3 + i/3):accelerate(15):y(_screen.h):zoom(3)
		end
	}
end

t[#t+1] = t2
af[#af+1] = t

af[#af+1] = Def.Quad{
	InitCommand=function(self) fadeout = self end,
	OnCommand=function(self)
		self:diffuse(0,0,0,1):FullScreen():Center():accelerate(5):diffusealpha(0)
	end
}

return af